//JS to add an 'in-view' class to elements when they come into view
//Use to add @keyframe or tranistion animations to elements so animate once they are on screen
//Simply add the .animate class to those elements that you wish to animate
//Then define CSS to handle animations once that element is in view, such as h1.in-view { }
//Adapted from: https://www.sitepoint.com/scroll-based-animations-jquery-css3/
	
$(function() { 	//jQuery when document is ready...

	var $animation_elements = $('.animate'); //get all elments with .animate class assigned
	//add the .animate class to any element you wish to animate once in view
	var $window = $(window); //get reference to the current window

	//function that loops through all elements with .animate class assigned
	//checks if they are within the viewport of not and adds/removes 'in-view' class accordingly
	function check_if_in_view() {
	  var window_height = $window.height();
	  var window_top_position = $window.scrollTop();
	  var window_bottom_position = (window_top_position + window_height);

	  $.each($animation_elements, function() {
		var $element = $(this);
		var element_height = $element.outerHeight();
		var element_top_position = $element.offset().top;
		var element_bottom_position = (element_top_position + element_height);

		//check to see if this current container is within viewport
		if ((element_bottom_position >= window_top_position) &&
			(element_top_position <= window_bottom_position)) {
		  $element.addClass('in-view');
		} else {
		  $element.removeClass('in-view');
		}
	  });
	}

	$window.on('scroll resize', check_if_in_view); //check if the window is resized or scrolled and call function if so
	$window.trigger('scroll');

});